<?php
session_start();
require_once '../includes/header.php'; 

$page_title = "Masaların Statusu";
$current_user_id = $_SESSION['user_id'] ?? null; 

if ($_SESSION['role'] !== 'waiter' && $_SESSION['role'] !== 'admin' || !$current_user_id) {
    header('Location: ../index.php');
    exit;
}

$message = $_GET['message'] ?? '';
$error = $_GET['error'] ?? '';
$filter_my_tables = isset($_GET['filter']) && $_GET['filter'] === 'my';

// --- STATİSTİKA SORĞULARI ---
$my_pending_amount = 0; 
$today_my_sales_amount = 0; 

// 1. Mənim Aktiv Sifarişlərim
$sql_pending = "SELECT IFNULL(SUM(total_amount), 0) AS total FROM orders WHERE status IN ('new', 'active') AND waiter_id = '$current_user_id'";
$res = $conn->query($sql_pending);
$my_pending_amount = $res ? $res->fetch_assoc()['total'] : 0;

// 2. Mənim Bugünki Satışım
$today_start = date('Y-m-d 00:00:00');
$sql_today = "SELECT IFNULL(SUM(total_amount), 0) AS total FROM orders WHERE status = 'paid' AND closed_date >= '$today_start' AND waiter_id = '$current_user_id'";
$res_today = $conn->query($sql_today);
$today_my_sales_amount = $res_today ? $res_today->fetch_assoc()['total'] : 0;

// --- MASALARIN SORĞUSU (Burada sort_order əlavə edildi) ---
$sql_tables = "
    SELECT 
        t.id, t.table_number, t.capacity, 
        o.id AS order_id, o.status AS order_status, IFNULL(o.total_amount, 0) AS total_amount,
        o.order_date AS order_start_time, o.waiter_id, 
        COALESCE(CONCAT(u.first_name, ' ', u.last_name), 'Naməlum') AS waiter_fullname,
        (SELECT COUNT(*) FROM order_items WHERE order_id = o.id) AS item_count
    FROM tables t
    LEFT JOIN orders o ON t.id = o.table_id AND o.status IN ('new', 'active')
    LEFT JOIN users u ON o.waiter_id = u.id 
    WHERE 1=1 " . ($filter_my_tables ? " AND (o.waiter_id = '$current_user_id' OR o.id IS NULL)" : "") . "
    ORDER BY t.sort_order ASC, t.table_number ASC"; // Sənin istədiyin sıralama

$result = $conn->query($sql_tables);
$tables = $result ? $result->fetch_all(MYSQLI_ASSOC) : [];

function format_order_time($time) {
    return $time ? date('H:i', strtotime($time)) : '';
}
?>

<style>
    :root {
        --pos-bg: #f4f7f6;
        --card-empty: #ffffff;
        --card-mine: #e3f2fd;
        --card-busy: #fff3e0;
        --accent-color: #4361ee;
    }
    body { background-color: var(--pos-bg); font-family: 'Inter', sans-serif; }
    
    .stats-card {
        border: none;
        border-radius: 15px;
        transition: transform 0.2s;
        background: linear-gradient(135deg, #4361ee, #3a0ca3);
        color: white;
    }

    .table-card {
        border: none;
        border-radius: 20px;
        transition: all 0.3s cubic-bezier(.25,.8,.25,1);
        overflow: hidden;
        position: relative;
    }
    .table-card:hover { transform: translateY(-5px); box-shadow: 0 10px 20px rgba(0,0,0,0.1); }
    
    .table-status-badge {
        position: absolute;
        top: 15px;
        right: 15px;
        padding: 5px 12px;
        border-radius: 50px;
        font-size: 0.7rem;
        font-weight: 700;
        text-transform: uppercase;
    }

    /* Status Rəngləri */
    .status-empty { border-top: 5px solid #2ec4b6; }
    .status-mine { border-top: 5px solid #e71d36; background-color: #fff5f5; }
    .status-others { border-top: 5px solid #ff9f1c; opacity: 0.85; }

    .table-icon-circle {
        width: 70px;
        height: 70px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 15px;
        background: rgba(0,0,0,0.03);
    }
    
    .btn-action {
        border-radius: 12px;
        padding: 10px;
        font-weight: 600;
        letter-spacing: 0.5px;
    }

    .filter-pills .btn {
        border-radius: 50px;
        padding: 8px 20px;
        font-weight: 600;
        border: 2px solid var(--accent-color);
    }
    .filter-pills .btn.active { background-color: var(--accent-color); color: white; }

    @media (max-width: 576px) {
        .card-title { font-size: 1.1rem; }
        .table-icon-circle { width: 50px; height: 50px; }
        .table-icon-circle i { font-size: 1.5rem !important; }
    }
</style>

<div class="container py-4">
    <div class="row g-3 mb-4" style="margin-bottom: 1rem !important;">
        <div class="col-6 col-md-3">
            <div class="card stats-card p-3 shadow-sm">
                <small class="opacity-75">Açıq Masalarım</small>
                <h3 class="fw-bold mb-0"><?= number_format($my_pending_amount, 2) ?> ₼</h3>
                <i class="fas fa-wallet position-absolute end-0 bottom-0 m-3 opacity-25 fa-2x"></i>
            </div>
        </div>
        <div class="col-6 col-md-3">
            <div class="card stats-card p-3 shadow-sm" style="background: linear-gradient(135deg, #2ec4b6, #088395);">
                <small class="opacity-75">Bugünki Satışım</small>
                <h3 class="fw-bold mb-0"><?= number_format($today_my_sales_amount, 2) ?> ₼</h3>
                <i class="fas fa-check-double position-absolute end-0 bottom-0 m-3 opacity-25 fa-2x"></i>
            </div>
        </div>
    </div>

    <div class="d-flex flex-column flex-md-row justify-content-between align-items-center mb-4 gap-3" style="margin-bottom: 1rem !important;">
        <h4 class="fw-bold text-secondary mb-0"><i class="fas fa-th-large me-2"></i>Masa Planı</h4>
        <div class="btn-group filter-pills shadow-sm">
            <a href="index.php" class="btn btn-outline-primary <?= !$filter_my_tables ? 'active' : '' ?>">Bütün Masalar</a>
            <a href="index.php?filter=my" class="btn btn-outline-primary <?= $filter_my_tables ? 'active' : '' ?>">Mənimkilər</a>
        </div>
    </div>

    <div class="row g-3">
        <?php foreach ($tables as $table): 
            $has_order = !empty($table['order_id']);
            $is_mine = $has_order && ($table['waiter_id'] == $current_user_id);
            $is_admin = $_SESSION['role'] === 'admin';
            
            $card_type_class = 'status-empty';
            $badge_text = 'BOŞ';
            $badge_class = 'bg-success text-white';
            $icon_color = 'text-success';
            
            if ($has_order) {
                if ($is_mine) {
                    $card_type_class = 'status-mine';
                    $badge_text = 'MƏNİMDİR';
                    $badge_class = 'bg-danger text-white';
                    $icon_color = 'text-danger';
                } else {
                    $card_type_class = 'status-others';
                    $badge_text = explode(' ', $table['waiter_fullname'])[0];
                    $badge_class = 'bg-warning text-dark';
                    $icon_color = 'text-warning';
                }
            }
        ?>
        <div class="col-6 col-md-4 col-lg-3">
            <div class="card table-card h-100 shadow-sm <?= $card_type_class ?>">
                <span class="table-status-badge <?= $badge_class ?>"><?= $badge_text ?></span>
                
                <div class="card-body d-flex flex-column pt-5">
                    <div class="table-icon-circle">
                        <i class="fas fa-utensils fa-2x <?= $icon_color ?>"></i>
                    </div>
                    
                    <h5 class="card-title fw-bold text-center mb-1"><?= htmlspecialchars($table['table_number']) ?></h5>
                    <p class="text-center text-muted small mb-3">Tutum: <?= $table['capacity'] ?> nəfər</p>

                    <?php if ($has_order): ?>
                        <div class="bg-white rounded-3 p-2 mb-3 border border-light shadow-sm">
                            <div class="d-flex justify-content-between mb-1">
                                <span class="text-muted small">Məbləğ:</span>
                                <span class="fw-bold text-danger"><?= number_format($table['total_amount'], 2) ?> ₼</span>
                            </div>
                            <div class="d-flex justify-content-between">
                                <span class="text-muted small">Saat:</span>
                                <span class="fw-bold small"><?= format_order_time($table['order_start_time']) ?></span>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-3">
                            <span class="text-success small fw-bold">Hazırdır</span>
                        </div>
                    <?php endif; ?>

                    <div class="mt-auto">
                        <?php if (!$has_order): ?>
                            <a href="order_create.php?table_id=<?= $table['id'] ?>" class="btn btn-success w-100 btn-action shadow-sm">
                                <i class="fas fa-plus me-1"></i> AÇ
                            </a>
                        <?php elseif ($is_mine || $is_admin): ?>
                            <a href="order_view.php?order_id=<?= $table['order_id'] ?>" class="btn btn-primary w-100 btn-action shadow-sm">
                                <i class="fas fa-eye me-1"></i> BAX
                            </a>
                        <?php else: ?>
                            <button class="btn btn-light w-100 btn-action text-muted" onclick="alert('Bu masa <?= addslashes($table['waiter_fullname']) ?> tərəfindən idarə olunur.')">
                                <i class="fas fa-lock me-1"></i> MƏŞĞUL
                            </button>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
</div>

<?php require_once '../includes/footer.php'; ?>