<?php
session_start();
$page_title = "Satış Hesabatı";
require_once '../includes/header.php'; 
require_once '../config/db.php'; 

if ($_SESSION['role'] !== 'admin') {
    header('Location: index.php');
    exit;
}

// Tarix Filtrləri
$start_date = $_GET['start_date'] ?? date('Y-m-d');
$end_date   = $_GET['end_date'] ?? date('Y-m-d');
$waiter_id  = $_GET['waiter_id'] ?? '';

$start_dt = $start_date . ' 00:00:00';
$end_dt   = $end_date   . ' 23:59:59';

// Ofisiantlar
$waiters = $conn->query("SELECT id, first_name, last_name FROM users WHERE role = 'waiter'")->fetch_all(MYSQLI_ASSOC);

// Dinamik Statistika (KPI)
$where_orders = " WHERE o.status = 'paid' AND o.order_date BETWEEN '$start_dt' AND '$end_dt'";
if ($waiter_id != '') { $where_orders .= " AND o.waiter_id = " . (int)$waiter_id; }

$kpi_query = $conn->query("
    SELECT 
        SUM(o.total_amount) as grand_total, 
        COUNT(DISTINCT o.id) as order_count, 
        SUM(oi.quantity) as total_items 
    FROM orders o 
    LEFT JOIN order_items oi ON o.id = oi.order_id 
    $where_orders");
$kpi = $kpi_query->fetch_assoc();

// Ümumi Sistem Sayğacları
$c_cat   = $conn->query("SELECT COUNT(*) FROM categories")->fetch_row()[0];
$c_menu  = $conn->query("SELECT COUNT(*) FROM menu_items")->fetch_row()[0];
$c_user  = $conn->query("SELECT COUNT(*) FROM users")->fetch_row()[0];
$c_table = $conn->query("SELECT COUNT(*) FROM tables")->fetch_row()[0];

// Kabinetləri 'type' sütununa görə tapırıq
$c_room  = $conn->query("SELECT COUNT(*) FROM tables WHERE type = 'kabinet'")->fetch_row()[0];

// Məhsul Satışı Sorğusu
$products = $conn->query("
    SELECT mi.name, oi.price_at_order, SUM(oi.quantity) as total_qty, SUM(oi.price_at_order * oi.quantity) as total_revenue
    FROM order_items oi 
    JOIN orders o ON oi.order_id = o.id 
    JOIN menu_items mi ON oi.menu_item_id = mi.id
    $where_orders 
    GROUP BY mi.id, oi.price_at_order 
    ORDER BY total_qty DESC");
?>

<style>
    .stat-card { 
        border: none; 
        border-radius: 18px; 
        transition: all 0.3s ease; 
        color: white; 
        position: relative;
        overflow: hidden;
        min-height: 125px;
        box-shadow: 0 8px 15px rgba(0,0,0,0.1);
    }
    .stat-card:hover { transform: translateY(-7px); box-shadow: 0 12px 25px rgba(0,0,0,0.2); }
    .icon-bg { 
        font-size: 3.5rem; 
        position: absolute; 
        right: -5px; 
        bottom: -5px; 
        opacity: 0.2; 
    }
    
    /* Tünd və Müasir Qradientlər */
    .bg-main-kassa { background: linear-gradient(135deg, #232526 0%, #414345 100%); } 
    .bg-main-orders { background: linear-gradient(135deg, #1e3c72 0%, #2a5298 100%); }
    .bg-main-items { background: linear-gradient(135deg, #134e5e 0%, #71b280 100%); }
    .bg-sys-card { background: linear-gradient(135deg, #434343 0%, #000000 100%); }
    
    .table-responsive { border-radius: 15px; }
    .rounded-input { border-radius: 12px !important; }
</style>

<div class="container py-4">
    <h3 class="fw-bold mb-4 text-dark"><i class="fas fa-chart-pie me-2"></i>Satış Analitikası</h3>

    <div class="card shadow-sm mb-4 border-0" style="border-radius: 15px;">
        <div class="card-body p-3">
            <form method="GET" class="row g-2 align-items-end">
                <div class="col-md-3">
                    <label class="small fw-bold text-muted ms-2">Başlanğıc</label>
                    <input type="date" name="start_date" class="form-control rounded-input" value="<?= $start_date ?>">
                </div>
                <div class="col-md-3">
                    <label class="small fw-bold text-muted ms-2">Bitiş</label>
                    <input type="date" name="end_date" class="form-control rounded-input" value="<?= $end_date ?>">
                </div>
                <div class="col-md-3">
                    <label class="small fw-bold text-muted ms-2">Ofisiant</label>
                    <select name="waiter_id" class="form-select rounded-input">
                        <option value="">Bütün Heyət</option>
                        <?php foreach($waiters as $w): ?>
                            <option value="<?= $w['id'] ?>" <?= $waiter_id == $w['id'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($w['first_name'].' '.$w['last_name']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <button type="submit" class="btn btn-primary w-100 rounded-input fw-bold py-2 shadow-sm">YENİLƏ</button>
                </div>
            </form>
        </div>
    </div>

    <div class="row g-3 mb-4">
        <div class="col-md-4">
            <div class="card stat-card bg-main-kassa p-4">
                <div class="small fw-bold text-uppercase opacity-75">Ümumi Kassa</div>
                <div class="h2 fw-bold mb-0 mt-2"><?= number_format($kpi['grand_total'] ?? 0, 2) ?> ₼</div>
                <i class="fas fa-coins icon-bg"></i>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card stat-card bg-main-orders p-4">
                <div class="small fw-bold text-uppercase opacity-75">Sifariş Sayı</div>
                <div class="h2 fw-bold mb-0 mt-2"><?= $kpi['order_count'] ?> Qəbz</div>
                <i class="fas fa-clipboard-list icon-bg"></i>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card stat-card bg-main-items p-4">
                <div class="small fw-bold text-uppercase opacity-75">Satılan Məhsul</div>
                <div class="h2 fw-bold mb-0 mt-2"><?= (int)$kpi['total_items'] ?> Ədəd</div>
                <i class="fas fa-hotdog icon-bg"></i>
            </div>
        </div>
    </div>

    <div class="row g-3 mb-4">
        <div class="col-md">
            <div class="card stat-card bg-sys-card p-3 text-center">
                <i class="fas fa-folder-open mb-1 text-info"></i>
                <div class="h5 mb-0 fw-bold"><?= $c_cat ?></div>
                <div class="small opacity-50" style="font-size: 0.7rem;">Kateqoriya</div>
            </div>
        </div>
        <div class="col-md">
            <div class="card stat-card bg-sys-card p-3 text-center">
                <i class="fas fa-utensils mb-1 text-warning"></i>
                <div class="h5 mb-0 fw-bold"><?= $c_menu ?></div>
                <div class="small opacity-50" style="font-size: 0.7rem;">Məhsul</div>
            </div>
        </div>
        <div class="col-md">
            <div class="card stat-card bg-sys-card p-3 text-center">
                <i class="fas fa-user-shield mb-1 text-success"></i>
                <div class="h5 mb-0 fw-bold"><?= $c_user ?></div>
                <div class="small opacity-50" style="font-size: 0.7rem;">Personal</div>
            </div>
        </div>
        <div class="col-md">
            <div class="card stat-card bg-sys-card p-3 text-center">
                <i class="fas fa-border-all mb-1 text-danger"></i>
                <div class="h5 mb-0 fw-bold"><?= $c_table ?></div>
                <div class="small opacity-50" style="font-size: 0.7rem;">Masa</div>
            </div>
        </div>
        <div class="col-md">
            <div class="card stat-card bg-sys-card p-3 text-center">
                <i class="fas fa-door-closed mb-1 text-primary"></i>
                <div class="h5 mb-0 fw-bold"><?= $c_room ?></div>
                <div class="small opacity-50" style="font-size: 0.7rem;">Kabinet</div>
            </div>
        </div>
    </div>

    <div class="card border-0 shadow-sm" style="border-radius: 15px; overflow: hidden;">
        <div class="card-header bg-white py-3">
            <h6 class="mb-0 fw-bold text-secondary"><i class="fas fa-list-ol me-2"></i>Məhsul Bazlı Satış Detalları</h6>
        </div>
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="bg-light">
                    <tr>
                        <th class="ps-4">MƏHSUL</th>
                        <th class="text-center">SATIŞ QİYMƏTİ</th>
                        <th class="text-center">SAY</th>
                        <th class="text-end pe-4">TOPLAM GƏLİR</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if($products && $products->num_rows > 0): ?>
                        <?php while($row = $products->fetch_assoc()): ?>
                        <tr>
                            <td class="ps-4 fw-bold text-dark"><?= htmlspecialchars($row['name']) ?></td>
                            <td class="text-center"><?= number_format($row['price_at_order'], 2) ?> ₼</td>
                            <td class="text-center"><span class="badge bg-primary rounded-pill px-3"><?= $row['total_qty'] ?></span></td>
                            <td class="text-end pe-4 fw-bold text-dark"><?= number_format($row['total_revenue'], 2) ?> ₼</td>
                        </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr><td colspan="4" class="text-center py-5">Seçilmiş tarixdə satış qeydə alınmayıb.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php require_once '../includes/footer.php'; ?>