<?php
session_start();
$page_title = "Sifarişə Baxış və Ödəniş";
require_once '../includes/header.php'; 
require_once '../config/db.php'; 


// Yalnız Ofisiant (və ya Admin) giriş edə bilər
if ($_SESSION['role'] !== 'waiter' && $_SESSION['role'] !== 'admin') {
    header('Location: ../index.php');
    exit;
}

$order_id = (int)($_GET['order_id'] ?? 0);
$message = $_GET['message'] ?? '';
$error = $_GET['error'] ?? '';

if ($order_id === 0) {
    header('Location: index.php?error=' . urlencode('Sifariş ID-si tapılmadı.'));
    exit;
}

$order_total = 0;

// Ayarları settings cədvəlindən oxu (Sənin sütun adların: key və value)
$settings = [];
$settings_res = $conn->query("SELECT `key`, `value` FROM settings WHERE `key` IN ('default_service_fee_percent', 'restaurant_name')");
while ($row = $settings_res->fetch_assoc()) {
    $settings[$row['key']] = $row['value'];
}

$restoran_adi = $settings['restaurant_name'] ?? 'MyPOS Restaurant';
$service_percentage = (float)($settings['default_service_fee_percent'] ?? 0);

// Servis haqqını hesabla
$service_amount = ($order_total * $service_percentage) / 100;
$grand_total = $order_total + $service_amount;

function sendTelegramNotification($message) {
    $token = "8534963011:AAEDKeD7RAbyCn-k8GD-QLDuT6QSM2wrePo"; 
    $chat_id = "1246936980";     
    $url = "https://api.telegram.org/bot$token/sendMessage?chat_id=$chat_id&text=" . urlencode($message) . "&parse_mode=HTML";
    @file_get_contents($url);
}
function updateOrderTotal($conn, $order_id) {
    global $order_total;
    $sql = "UPDATE orders o 
            SET total_amount = (
                SELECT IFNULL(SUM(oi.quantity * oi.price_at_order), 0) 
                FROM order_items oi 
                WHERE oi.order_id = ?
            )
            WHERE o.id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ii", $order_id, $order_id);
    $stmt->execute();
    $stmt->close();

    $stmt_fetch = $conn->prepare("SELECT total_amount FROM orders WHERE id = ?");
    $stmt_fetch->bind_param("i", $order_id);
    $stmt_fetch->execute();
    if ($row = $stmt_fetch->get_result()->fetch_assoc()) {
        $order_total = $row['total_amount'];
    }
    $stmt_fetch->close();
}


// --- B. POST Əməliyyatları (YENİLƏNMİŞ SİLİNMƏ MƏNTİQİ) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    $redirect_url = 'order_view.php?order_id=' . $order_id;
    $current_user_id = $_SESSION['user_id']; 

    // Miqdar dəyişməsi/silməsi
if ($action === 'update_item_qty') {
    $item_id = (int)$_POST['item_id'];
    $new_quantity = (int)$_POST['quantity'];
    $delete_reason = $_POST['delete_reason'] ?? 'Səbəb qeyd edilməyib';

    // 1. Məlumatları bazadan tam çəkirik
    $stmt_fetch = $conn->prepare("
        SELECT 
            oi.quantity AS old_qty, 
            mi.name AS mehsul_adi, 
            t.table_number AS masa_no, 
            u.first_name, 
            u.last_name,
            o.status AS order_status
        FROM order_items oi
        LEFT JOIN menu_items mi ON oi.menu_item_id = mi.id
        LEFT JOIN orders o ON oi.order_id = o.id
        LEFT JOIN tables t ON o.table_id = t.id
        LEFT JOIN users u ON o.waiter_id = u.id
        WHERE oi.id = ? AND oi.order_id = ?
    ");
    $stmt_fetch->bind_param("ii", $item_id, $order_id);
    $stmt_fetch->execute();
    $item_data = $stmt_fetch->get_result()->fetch_assoc();
    $stmt_fetch->close();

    if ($item_data) {
        $old_quantity = (int)$item_data['old_qty'];

        // 2. Əgər miqdar azaldılırsa Telegram-a bildiriş göndər
        if ($new_quantity < $old_quantity) {
            $deleted_qty = $old_quantity - $new_quantity;
            
            // Dəyişənləri hazırlayırıq (boş qalsa 'Məlumat yoxdur' yazacaq)
            $m_adi = !empty($item_data['mehsul_adi']) ? $item_data['mehsul_adi'] : "Məhsul adı tapılmadı";
            $m_no = !empty($item_data['masa_no']) ? $item_data['masa_no'] : "Masa tapılmadı";
            $o_adi = (!empty($item_data['first_name']) || !empty($item_data['last_name'])) 
                     ? ($item_data['first_name'] . " " . $item_data['last_name']) 
                     : "Ofisiant tapılmadı";
            $current_time = date('d.m.Y H:i:s');

            $tg_msg = "❌ <b>SİFARİŞDƏN SİLİNMƏ</b>\n\n";
            $tg_msg .= "🪑 <b>Masa:</b> " . $m_no . "\n";
            $tg_msg .= "🍔 <b>Məhsul:</b> " . $m_adi . "\n";
            $tg_msg .= "🔢 <b>Silinən say:</b> " . $deleted_qty . " ədəd\n";
            $tg_msg .= "📉 <b>Yeni qalıq:</b> " . $new_quantity . " ədəd\n";
            $tg_msg .= "👤 <b>Ofisiant:</b> " . $o_adi . "\n";
            $tg_msg .= "⏰ <b>Vaxt:</b> " . $current_time;

            sendTelegramNotification($tg_msg);
        }
    }
         $deleted_qty = 0;
         $log_deletion = false;
         
         
         // Yalnız miqdar azalanda və ya sıfır olanda bu hissə işləyəcək
         if ($new_quantity < $old_quantity) {
            
             // Status aktivdirsə, fərqi silinmə kimi qeydə al
             // VƏ YALNIZ pending xətləri silinə bilər (Delivered olanlar silinə bilməz, bu məntiqi əlavə etmək lazımdır)
             // Qeyd: Bu kodda silinmə delivered statusundan asılı deyil, çünki delivered olan xətt onsuz da redaktə düyməsi göstərmir.
             if ($item_data['status'] === 'active') {
                 $deleted_qty = $old_quantity - $new_quantity;
                 $log_deletion = true;
             }
         }
         
         // ----------------------------------------------------
         // 2. Məhsulun silinməsi (Miqdarın 0-a düşməsi)
         if ($new_quantity <= 0) {
             
             // Əsas xətti sil
             $stmt = $conn->prepare("DELETE FROM order_items WHERE id = ? AND order_id = ?");
             $stmt->bind_param("ii", $item_id, $order_id);
             $stmt->execute();
             $stmt->close();
             $message = "Məhsul xətti sifarişdən silindi.";
             
         } 
         // 3. Miqdarın yenilənməsi (Miqdarın artması və ya azalması, lakin 0 olmaması)
         else {
             $stmt = $conn->prepare("UPDATE order_items SET quantity = ? WHERE id = ? AND order_id = ?");
             $stmt->bind_param("iii", $new_quantity, $item_id, $order_id);
             if ($stmt->execute()) {
                 $message = "Məhsul xəttinin miqdarı yeniləndi.";
             } else {
                 $error = "Miqdarı dəyişmək mümkün olmadı.";
                 $log_deletion = false; // Xəta oldusa loglama
             }
             $stmt->close();
         }
         // ----------------------------------------------------


         // 4. Silinməni jurnalda qeyd et
         if ($log_deletion && $deleted_qty > 0) {
             $stmt_log = $conn->prepare("
                 INSERT INTO deleted_order_items (order_id, waiter_id, table_number, menu_item_name, quantity, price_at_delete) 
                 VALUES (?, ?, ?, ?, ?, ?)
             ");
             $stmt_log->bind_param(
                 "iissid", 
                 $order_id, 
                 $current_user_id, 
                 $item_data['table_number'], 
                 $item_data['name'], 
                 $deleted_qty, 
                 $item_data['price_at_order']
             );
             if ($stmt_log->execute()) {
                 $message .= " (" . $deleted_qty . " ədəd silinmə jurnalda qeyd edildi)";
             } else {
                 // Loglama xətası əsas əməliyyatı ləğv etməməlidir
                 // $error = "Silinməni jurnalda qeyd etmək mümkün olmadı: " . $stmt_log->error; 
             }
             $stmt_log->close();
         }
         
         // Total Amount yenilənir
         updateOrderTotal($conn, $order_id); 
        
         // Sifarişdə heç nə qalmayıbsa, sifarişi ləğv et
         $count_result = $conn->query("SELECT COUNT(id) AS item_count FROM order_items WHERE order_id = $order_id");
         if ($count_result && $count_result->fetch_assoc()['item_count'] == 0) {
              $conn->query("UPDATE orders SET status = 'cancelled' WHERE id = $order_id");
              header('Location: index.php?message=' . urlencode('Sifariş boş qaldığı üçün ləğv edildi.'));
              exit;
         }
    } 
    
    // --- YENİ ÇATDIRILMA MƏNTİQİ: MƏHSUL QURUPLARI ƏSASINDA (Dəyişikliksiz) ---
    else if ($action === 'mark_group_delivered') {
        $menu_item_id = (int)$_POST['menu_item_id'];
        
        // Həmin məhsulun (menu_item_id) verilmiş sifarişdə (order_id) 'pending' olan BÜTÜN xətlərini 'delivered' edir.
        $stmt = $conn->prepare("
            UPDATE order_items 
            SET delivery_status = 'delivered' 
            WHERE order_id = ? 
              AND menu_item_id = ? 
              AND delivery_status = 'pending'
        ");
        $stmt->bind_param("ii", $order_id, $menu_item_id);
        
        if ($stmt->execute() && $stmt->affected_rows > 0) {
            $message = "Məhsulun bütün yeni hissələri masaya çatdırıldı (Delivered) olaraq qeyd edildi.";
        } else {
            $error = "Çatdırılacaq yeni məhsul hissəsi tapılmadı və ya sifariş aktiv deyil.";
        }
        $stmt->close();
    }
    
    else if ($action === 'confirm_order') {
        // ... (Təsdiqləmə məntiqi eyni qalır) ...
        $count_result = $conn->query("SELECT COUNT(id) AS item_count FROM order_items WHERE order_id = $order_id");
        if ($count_result && $count_result->fetch_assoc()['item_count'] == 0) {
             $error = "Sifarişi təsdiqləmək üçün heç olmasa bir məhsul əlavə edilməlidir.";
        } else {
            $stmt = $conn->prepare("UPDATE orders SET status = 'active' WHERE id = ? AND status = 'new'");
            $stmt->bind_param("i", $order_id);
            if ($stmt->execute()) {
                $message = "Sifariş uğurla TƏSDİQLƏNDİ və mətbəxə göndərildi. Masa statusu AKTİV edildi.";
            } else {
                $error = "Sifarişi təsdiqləmək mümkün olmadı.";
            }
            $stmt->close();
        }
    }
    
else if ($action === 'finalize_order') {
    $payment_method = $_POST['payment_method'] ?? 'cash';
    $closed_date = date('Y-m-d H:i:s');

    // 1. Öncə sifarişin xalis məbləğini (servissiz) bazadan yenidən çəkirik
    $stmt_check = $conn->prepare("SELECT SUM(quantity * price_at_order) as net_total FROM order_items WHERE order_id = ?");
    $stmt_check->bind_param("i", $order_id);
    $stmt_check->execute();
    $res = $stmt_check->get_result()->fetch_assoc();
    $net_total = (float)($res['net_total'] ?? 0);
    $stmt_check->close();

    // 2. Servis haqqını hesablayaq (settings-dən gələn faizlə)
    $service_fee = ($net_total * $service_percentage) / 100;
    $final_amount = $net_total + $service_fee;

    // 3. İndi isə düzgün hesablanmış final_amount-u bazaya yazırıq
    $stmt = $conn->prepare("UPDATE orders SET status = 'paid', payment_method = ?, closed_date = ?, total_amount = ? WHERE id = ?");
    $stmt->bind_param("ssdi", $payment_method, $closed_date, $final_amount, $order_id);
    
    if ($stmt->execute()) {
        header("Location: index.php?message=" . urlencode("Sifariş bağlandı və ödəniş qeyd edildi."));
        exit;
    }
}


    // Əgər yönləndirmə olmayıbsa, səhifəni yenilə
    header('Location: ' . $redirect_url . '&message=' . urlencode($message) . '&error=' . urlencode($error));
    exit;
}


// --- C. Bütün Lazımi Datayı Yükləmək (READ) ---
$order = [];
$grouped_items = []; // Qruplaşdırılmış məhsullar üçün yeni dəyişən

$order_sql = "
    SELECT 
        o.id, o.table_id, t.table_number, o.waiter_id, u.first_name, u.last_name, 
        o.order_date, o.status, o.total_amount, o.closed_date, o.payment_method
    FROM orders o
    JOIN tables t ON o.table_id = t.id
    JOIN users u ON o.waiter_id = u.id 
    WHERE o.id = ?
";
$stmt = $conn->prepare($order_sql);
$stmt->bind_param("i", $order_id);
$stmt->execute();
$order_result = $stmt->get_result();
$order = $order_result->num_rows === 1 ? $order_result->fetch_assoc() : [];
$order_total = $order['total_amount'] ?? 0;
$stmt->close();

if (empty($order)) {
    $error = "Sifariş tapılmadı.";
    require_once '../includes/footer.php';
    exit;
}
$is_order_active = $order['status'] === 'active'; 
$is_order_new = $order['status'] === 'new';
$is_editable = $is_order_active || $is_order_new; 


// 2. Sifariş Xətləri (Məhsullar) - QRUPLAŞDIRILMA
$items_sql = "
    SELECT 
        oi.id, oi.menu_item_id, mi.name AS item_name, oi.quantity, oi.price_at_order, oi.delivery_status, oi.item_add_date
    FROM order_items oi
    JOIN menu_items mi ON oi.menu_item_id = mi.id
    WHERE oi.order_id = ?
    ORDER BY oi.item_add_date ASC, oi.id ASC
";
$stmt = $conn->prepare($items_sql);
$stmt->bind_param("i", $order_id);
$stmt->execute();
$items_result = $stmt->get_result();
$raw_items = $items_result->fetch_all(MYSQLI_ASSOC);
$stmt->close();

// Məhsulları Qruplaşdırırıq: menu_item_id və delivery_status-a görə
$grouped_items = [];
foreach ($raw_items as $item) {
    $menu_item_id = $item['menu_item_id'];
    $status = $item['delivery_status'];
    
    if (!isset($grouped_items[$menu_item_id])) {
        $grouped_items[$menu_item_id] = [
            'item_name' => $item['item_name'],
            'price' => $item['price_at_order'],
            'total_delivered' => 0,
            'total_pending' => 0,
        ];
    }
    
    $qty = (int)$item['quantity'];
    
    if ($status === 'delivered') {
        $grouped_items[$menu_item_id]['total_delivered'] += $qty;
    } else {
        $grouped_items[$menu_item_id]['total_pending'] += $qty;
    }
}


// 3. Menyu Məlumatları (Eyni qalır)
$menu = []; 
$cat_result = $conn->query("SELECT id, name FROM categories ORDER BY sort_order ASC");
if ($cat_result) {
    while($cat = $cat_result->fetch_assoc()) {
        $menu[$cat['id']] = ['name' => $cat['name'], 'items' => []];
    }
}
$item_sql = "SELECT id, category_id, name, sale_price FROM menu_items ORDER BY sort_order ASC";
$item_result = $conn->query($item_sql);
if ($item_result) {
    while($item = $item_result->fetch_assoc()) {
        if (isset($menu[$item['category_id']])) {
            $menu[$item['category_id']]['items'][] = $item;
        }
    }
}
?>

<style>
    /* Custom Stiller (Sizdə yox idi, amma dizayn üçün qeyd edirəm) */
    .sticky-card {
        position: sticky;
        top: 20px; 
    }
    .item-list-container {
        max-height: 75vh; 
        overflow-y: auto;
    }
</style>

<style>
/* Mobil Üçün Əsas Tənzimləmələr */
body {
    background-color: #f8f9fa;
    padding-bottom: 300px; /* Aşağıdakı səbət hissəsi üçün boşluq */
}

/* 1. Kateqoriyalar: Üfüqi Sürüşdürmə (Horizontal Scroll) */
.category-tabs-container {
    position: sticky;
    top: 0;
    z-index: 1020;
    background: #fff;
    padding: 10px 5px;
    border-bottom: 1px solid #eee;
    display: flex;
    overflow-x: auto;
    gap: 8px;
    scrollbar-width: none; /* Firefox */
}
.category-tabs-container::-webkit-scrollbar { display: none; } /* Chrome/Safari */

.cat-tab {
    flex: 0 0 auto;
    padding: 6px 15px;
    border-radius: 15px;
    border: 1px solid #ddd;
    background: #fdfdfd;
    font-size: 13px;
    font-weight: 600;
    white-space: nowrap;
}

.cat-tab.active {
    background: #007bff;
    color: #fff;
    border-color: #007bff;
}

/* 2. Menyu Kartları (Kompakt Dizayn) */
.menu-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 8px;
    padding: 10px;
}

.menu-card {
    background: #fff;
    border-radius: 10px;
    padding: 8px;
    border: 1px solid #eee;
    display: flex;
    flex-direction: column;
    justify-content: space-between;
    box-shadow: 0 2px 4px rgba(0,0,0,0.03);
}

.item-name {
    font-size: 12px;
    font-weight: 700;
    line-height: 1.2;
    margin-bottom: 4px;
    display: block;
    color: #333;
}

.item-price {
    font-size: 11px;
    color: #28a745;
    font-weight: bold;
}

/* 3. Miqdar Kontrolu (Kiçik və Rahat) */
.qty-control {
    display: flex;
    align-items: center;
    justify-content: space-between;
    background: #f1f1f1;
    border-radius: 5px;
    margin: 5px 0;
    height: 30px;
}

.qty-btn {
    width: 25px;
    border: none;
    background: none;
    font-size: 16px;
    font-weight: bold;
}

.qty-input {
    width: 25px;
    border: none;
    background: transparent;
    text-align: center;
    font-size: 12px;
    font-weight: bold;
}

.btn-add-cart {
    width: 100%;
    background: #333;
    color: white;
    border: none;
    border-radius: 5px;
    font-size: 11px;
    padding: 5px;
}

/* 4. SABİT SƏBƏT (Aşağı Hissə) */
.fixed-order-summary {
    position: fixed;
    bottom: 0;
    left: 0;
    right: 0;
    background: #fff;
    z-index: 1030;
    border-top: 2px solid #007bff;
    max-height: 280px;
    display: flex;
    flex-direction: column;
    box-shadow: 0 -5px 15px rgba(0,0,0,0.1);
}

.order-items-list {
    overflow-y: auto;
    padding: 10px;
    flex-grow: 1;
}

.mini-item-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 5px 0;
    border-bottom: 1px solid #f5f5f5;
    font-size: 12px;
}

.order-footer {
    padding: 10px;
    background: #f8f9fa;
    border-top: 1px solid #eee;
}

.total-row {
    display: flex;
    justify-content: space-between;
    font-weight: bold;
    font-size: 16px;
    margin-bottom: 10px;
}

/* Gizlətmə Düyməsi (Səbəti daraltmaq üçün) */
.toggle-summary {
    text-align: center;
    background: #eee;
    font-size: 10px;
    padding: 2px;
    cursor: pointer;
}

@media (min-width: 769px) {
    .fixed-order-summary { position: static; max-height: none; }
    body { padding-bottom: 0; }
}
</style>


<div class="container-fluid py-4">

<?php if ($message): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert"><i class="fas fa-check-circle me-2"></i> <?= htmlspecialchars($message) ?><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>
<?php endif; ?>
<?php if ($error): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert"><i class="fas fa-exclamation-triangle me-2"></i> <?= htmlspecialchars($error) ?><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>
<?php endif; ?>

<div class="row mb-4">
    <div class="col-12">
        <div class="card border-0 shadow-sm bg-light">
            <div class="card-body p-3">
                <div class="d-flex justify-content-between align-items-center flex-wrap">
                    <div class="d-flex align-items-center">
                        <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px;">
                            <i class="fas fa-utensils fa-lg"></i>
                        </div>
                        <div>
                            <h4 class="mb-0 fw-bold">Masa: <?= htmlspecialchars($order['table_number']) ?></h4>
                            <span class="text-muted small">Sifariş #<?= $order['id'] ?></span>
                        </div>
                    </div>
                    
                    <div class="mt-2 mt-md-0 d-flex align-items-center gap-2">
                        <a href="index.php" class="btn btn-primary shadow-sm px-4">
                            <i class="fas fa-home me-2"></i> Ana Səhifə
                    </a>

    <div class="text-md-end text-start ms-2">
        <div class="mb-1">
            <?php 
                if ($is_order_active) echo '<span class="badge rounded-pill bg-danger px-3">AKTİV SİFARİŞ</span>';
                elseif ($is_order_new) echo '<span class="badge rounded-pill bg-warning text-dark px-3">YENİ</span>';
                elseif ($order['status'] === 'paid') echo '<span class="badge rounded-pill bg-success px-3">ÖDƏNİLDİ</span>';
            ?>
        </div>
        <div class="small text-secondary">
            <i class="fas fa-user-circle me-1"></i> <?= htmlspecialchars($order['first_name']) ?> | 
            <i class="fas fa-clock me-1"></i> <?= date('H:i', strtotime($order['order_date'])) ?>
        </div>
    </div>
</div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    
    <div class="col-md-5 order-md-2 mb-4">
        <div class="card shadow sticky-card">
            <div class="card-header bg-primary text-white py-3">
                <h6 class="m-0 font-weight-bold">Sifariş Məhsulları (Qruplaşdırılmış)</h6>
            </div>
<div class="card-body p-0 item-list-container">
                <ul class="list-group list-group-flush">
                    <?php if (empty($grouped_items)): ?>
                           <li class="list-group-item text-center text-muted py-4">Sifarişə heç bir məhsul əlavə edilməyib.</li>
                    <?php else: ?>
                        <?php foreach ($grouped_items as $menu_item_id => $group): 
                            $total_qty = $group['total_delivered'] + $group['total_pending'];
                            $is_delivered = $group['total_pending'] === 0; 
                            $group_class = $is_delivered ? 'list-group-item-success' : ($group['total_delivered'] > 0 ? 'list-group-item-warning' : '');
                            $link_id = 'details_' . $menu_item_id;
                        ?>
                            <li class="list-group-item <?= $group_class ?>">
                                <div class="d-flex align-items-center justify-content-between mb-1">
                                    <div class="flex-grow-1">
                                        <strong><?= htmlspecialchars($group['item_name']) ?></strong>
                                        <span class="d-block small text-muted">Vahid Qiymət: <?= number_format($group['price'], 2) ?> AZN</span>
                                    </div>
                                    
                                    <div class="text-end">
                                        <span class="d-block fw-bold text-nowrap fs-5">
                                            <?= $total_qty ?> əd.
                                        </span>
                                        <span class="d-block small fw-bold text-primary">
                                            <?= number_format($total_qty * $group['price'], 2) ?> AZN
                                        </span>
                                    </div>
                                    
                                    <button class="btn btn-sm btn-outline-secondary ms-2" type="button" data-bs-toggle="collapse" data-bs-target="#<?= $link_id ?>" aria-expanded="false" aria-controls="<?= $link_id ?>" title="Xətlərə Baxış">
                                        <i class="fas fa-chevron-down"></i>
                                    </button>
                                </div>
                                
                                <div class="row mt-2 small">
                                    <div class="col-6">
                                        <span class="badge bg-success"><i class="fas fa-check"></i> Çatdırılıb: <?= $group['total_delivered'] ?></span>
                                    </div>
                                    <div class="col-6 text-end">
                                        <?php if ($group['total_pending'] > 0): ?>
                                            <span class="badge bg-danger"><i class="fas fa-clock"></i> Gözləyən: <?= $group['total_pending'] ?></span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                
                                <?php if ($is_order_active && $group['total_pending'] > 0): ?>
                                    <form action="order_view.php?order_id=<?= $order_id ?>" method="POST" class="d-grid mt-2">
                                        <input type="hidden" name="action" value="mark_group_delivered">
                                        <input type="hidden" name="menu_item_id" value="<?= $menu_item_id ?>">
                                        <button type="submit" class="btn btn-sm btn-warning">
                                            <i class="fas fa-truck-loading me-1"></i> <?= $group['total_pending'] ?> ədəd **Yeni Əlavələri** Çatdırıldı Et
                                        </button>
                                    </form>
                                <?php endif; ?>
                                
                                <div class="collapse mt-2" id="<?= $link_id ?>">
                                    <hr class="my-1">
                                    <p class="small fw-bold mb-1 text-primary">Sifariş Xətləri (Redaktə üçün):</p>
                                    <ul class="list-group list-group-flush border p-1 rounded">
                                        <?php 
                                        foreach ($raw_items as $item): 
                                            if ((int)$item['menu_item_id'] !== (int)$menu_item_id) continue;
                                            $is_item_delivered = $item['delivery_status'] === 'delivered';
                                        ?>
                                            <li class="list-group-item d-flex justify-content-between align-items-center p-1 bg-light">
                                                <div class="small">
                                                    <?= $item['quantity'] ?> əd.
                                                    <span class="text-muted">@ <?= date('H:i:s', strtotime($item['item_add_date'])) ?></span>
                                                    <span class="badge <?= $is_item_delivered ? 'bg-success' : 'bg-danger' ?> small ms-1"><?= $is_item_delivered ? 'Çatdırıldı' : 'Gözləyir' ?></span>
                                                </div>
                                                
                                                <?php if($is_editable && $item['delivery_status'] !== 'delivered'): ?>
                                                    <button type="button" class="btn btn-sm btn-info item-action-btn" 
                                                             data-item-id="<?= $item['id'] ?>" 
                                                             data-item-qty="<?= $item['quantity'] ?>"
                                                             title="Bu xəttin miqdarını dəyiş">
                                                         <i class="fas fa-edit"></i>
                                                     </button>
                                                <?php else: ?>
                                                    <span class="text-muted small">Qeydə alınıb</span>
                                                <?php endif; ?>
                                            </li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                            </li>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </ul>
            </div>
            
            <div class="card-footer bg-light py-3 border-primary border-top-0">
                <div class="d-flex justify-content-between align-items-center mb-3">
                 <?php 
// 1. Bazadan servis faizini təkrar yoxlayırıq (Ehtiyat üçün)
$service_percentage = 0;
$res_settings = $conn->query("SELECT `value` FROM settings WHERE `key` = 'default_service_fee_percent' LIMIT 1");
if ($res_settings && $row_s = $res_settings->fetch_assoc()) {
    // Tip xətası olmasın deyə təmizləyib rəqəmə çeviririk
    $service_percentage = floatval(preg_replace('/[^0-9.]/', '', $row_s['value']));
}

// 2. Hesablamanı aparırıq ($order_total yuxarıda artıq bəllidir)
$service_amount = ($order_total * $service_percentage) / 100;
$grand_total = $order_total + $service_amount;
?>

    <div class="d-flex justify-content-between align-items-center mb-1">
        <span class="text-muted small">Məhsullar cəmi:</span>
        <span class="fw-bold"><?= number_format($order_total, 2) ?> AZN</span>
    </div>

    <?php if ($service_percentage > 0): ?>
        <div class="d-flex justify-content-between align-items-center mb-1 text-primary">
            <span class="small">Servis haqqı (<?= $service_percentage ?>%):</span>
            <span class="fw-bold">+ <?= number_format($service_amount, 2) ?> AZN</span>
        </div>
    <?php endif; ?>

    <hr class="my-2">

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h5 class="mb-0 fw-bold">YEKUN:</h5>
        <h4 class="mb-0 text-success fw-bold"><?= number_format($grand_total, 2) ?> AZN</h4>
    </div>
</div>
                
                <?php if ($is_order_new): ?>
                    <form action="order_view.php?order_id=<?= $order_id ?>" method="POST" class="d-grid mb-3">
                        <input type="hidden" name="action" value="confirm_order">
                        <button type="submit" class="btn btn-warning btn-lg fw-bold" 
                                <?= empty($grouped_items) ? 'disabled' : '' ?>>
                            <i class="fas fa-paper-plane me-2"></i> Sifarişi TƏSDİQLƏ & Mətbəxə Göndər
                        </button>
                    </form>
                <?php endif; ?>

<?php if ($is_editable): ?>
    <div class="card border-primary shadow-sm mb-3">
        <div class="card-header bg-primary text-white py-2">
            <h6 class="mb-0 small"><i class="fas fa-cash-register me-1"></i> Hesabın Yekunlaşdırılması</h6>
        </div>
        <div class="card-body p-3">
            <form id="finalizeOrderForm" action="order_view.php?order_id=<?= $order_id ?>" method="POST">
                <input type="hidden" name="action" value="finalize_order"> 
                
                <div class="row g-2 mb-3">
                    <div class="col-12">
                        <label class="form-label small fw-bold text-muted mb-1">Ödəniş Üsulu:</label>
                        <div class="d-flex gap-2 flex-wrap">
                            <input type="radio" class="btn-check" name="payment_method" id="pay_cash" value="cash" checked>
                            <label class="btn btn-outline-secondary btn-sm flex-grow-1" for="pay_cash"><i class="fas fa-money-bill-wave"></i> Nağd</label>

                            <input type="radio" class="btn-check" name="payment_method" id="pay_terminal" value="terminal">
                            <label class="btn btn-outline-secondary btn-sm flex-grow-1" for="pay_terminal"><i class="fas fa-credit-card"></i> Terminal</label>

                            <input type="radio" class="btn-check" name="pay_card" id="pay_card" value="card">
                            <label class="btn btn-outline-secondary btn-sm flex-grow-1" for="pay_card"><i class="fas fa-mobile-alt"></i> Card to Card</label>
                        </div>
                    </div>
                </div>

                <div class="d-grid gap-2">
                    <button type="button" class="btn btn-success btn-lg fw-bold shadow-sm" onclick="printAndCloseOrder()">
                        <i class="fas fa-print me-2"></i> ÇEK ÇIXART VƏ BAĞLA
                    </button>
                    
                    <button type="button" class="btn btn-outline-dark btn-sm" onclick="onlyPrintReceipt()">
                        <i class="fas fa-search me-1"></i> Yalnız Çekə Bax (Bağlamadan)
                    </button>
                </div>
            </form>
        </div>
    </div>
<?php endif; ?>

<div id="thermal-receipt" style="display: none;">
    <div style="width: 80mm; font-family: 'Courier New', monospace; padding: 15px; color: black; background: white;">
        <center>
            <h2 style="margin: 0;"><?= htmlspecialchars($restoran_adi) ?></h2>
            <p style="margin: 5px 0;">Masa: <?= htmlspecialchars($order['table_number']) ?> | Sifariş: #<?= $order_id ?></p>
            <p style="margin: 0; font-size: 11px;">Tarix: <?= date('d.m.Y H:i') ?></p>
            <div style="border-top: 1px dashed #000; margin: 10px 0;"></div>
        </center>

        <table style="width: 100%; font-size: 12px; border-collapse: collapse;">
            <?php foreach ($grouped_items as $item): 
                $qty = $item['total_delivered'] + $item['total_pending']; ?>
                <tr>
                    <td style="padding: 3px 0;"><?= htmlspecialchars($item['item_name']) ?></td>
                    <td align="center"><?= $qty ?> x <?= number_format($item['price'], 2) ?></td>
                    <td align="right"><?= number_format($qty * $item['price'], 2) ?></td>
                </tr>
            <?php endforeach; ?>
        </table>

        <div style="border-top: 1px dashed #000; margin: 10px 0;"></div>

        <div style="font-size: 13px;">
<?php 
// 1. Bazadan servis faizini çəkirik
$service_percentage = 0; // Default olaraq 0
$res_settings = $conn->query("SELECT `value` FROM settings WHERE `key` = 'default_service_fee_percent' LIMIT 1");
if ($res_settings && $row_s = $res_settings->fetch_assoc()) {
    // Tip xətası olmasın deyə təmiz rəqəmə çeviririk
    $service_percentage = floatval(preg_replace('/[^0-9.]/', '', $row_s['value']));
}


$service_amount = ($order_total * $service_percentage) / 100;
$grand_total = $order_total + $service_amount;
?>

<div style="display: flex; justify-content: space-between;">
    <span>Cəmi:</span>
    <span><?= number_format($order_total, 2) ?> AZN</span>
</div>

<?php if ($service_percentage > 0): ?>
    <div style="display: flex; justify-content: space-between;">
        <span>Servis (<?= $service_percentage ?>%):</span>
        <span><?= number_format($service_amount, 2) ?> AZN</span>
    </div>
<?php endif; ?>

<div style="display: flex; justify-content: space-between; font-weight: bold; font-size: 16px; margin-top: 5px;">
    <span>YEKUN:</span>
    <span><?= number_format($grand_total, 2) ?> AZN</span>
</div>
        </div>

        <center style="margin-top: 20px; font-size: 11px;">
            <p>Ofisiant: <?= htmlspecialchars($order['first_name'] ?? 'Nurik') ?></p>
            <p>YENƏ GÖZLƏYİRİK!</p>
        </center>
    </div>
</div>

<script>
function printAndCloseOrder() {
    // 1. Çek məzmununu götür
    const receiptHtml = document.getElementById('thermal-receipt').innerHTML;
    
    // 2. Yeni gizli pəncərə və ya iframe yaratmadan birbaşa çap metodu
    const originalBody = document.body.innerHTML;
    document.body.innerHTML = receiptHtml;
    
    window.print();
    
    // 3. Formu bazaya göndər ki, masa qapansın
    document.body.innerHTML = originalBody;
    document.getElementById('finalizeOrderForm').submit();
}
</script>

<style>
@media print {
    body * { display: none !important; }
    #thermal-receipt { display: block !important; }
}
</style>
                
                <?php if ($order['status'] === 'paid'): ?>
                    <div class="alert alert-success text-center mt-3 p-2 small">
                        <i class="fas fa-info-circle me-1"></i> Sifariş tamamlanıb. Ödəniş metodu: **<?= strtoupper($order['payment_method']) ?>**
                    </div>
                <?php endif; ?>

                <div class="text-center mt-2">
                    <a href="index.php" class="btn btn-sm btn-outline-secondary">
                         <i class="fas fa-arrow-left me-2"></i> Masaların Siyahısına Geri Dön
                    </a>
                </div>
            </div>
        </div>
    </div>

    <style>
/* Kateqoriya Konteyneri */
.category-tabs-container {
    width: 100%;
    overflow-x: auto; /* Üfüqi sürüşdürmə */
    overflow-y: hidden; /* Aşağı sürüşməni bağla */
    display: block;
    position: relative;
    padding: 10px 0;
    -webkit-overflow-scrolling: touch; /* Mobil üçün hamar sürüşmə */
    scrollbar-width: thin; /* Firefox üçün incə scroll */
    scrollbar-color: #ccc transparent;
}

/* Kompüterdə Scrollbar-ı görünən edək */
.category-tabs-container::-webkit-scrollbar {
    height: 6px; /* Scroll-un hündürlüyü */
    display: block !important;
}

.category-tabs-container::-webkit-scrollbar-thumb {
    background-color: #ccc;
    border-radius: 10px;
}

.category-tabs-container::-webkit-scrollbar-track {
    background: #f1f1f1;
}

/* Tabların bir sırada qalmasını təmin edən əsas hissə */
.category-tabs {
    display: flex;
    flex-wrap: nowrap; /* Düymələrin aşağı düşməsini qəti qadağan edir */
    gap: 10px;
    padding-left: 5px;
    padding-right: 20px; /* Sonda bir az boşluq qalsın */
    min-width: max-content; /* İçindəki düymələr qədər genişlənir */
}

.cat-tab {
    flex: 0 0 auto; /* Düymələrin sıxılmasını maneə törədir */
    padding: 8px 18px;
    border-radius: 20px;
    border: 1px solid #ddd;
    background: #fff;
    white-space: nowrap; /* Yazının aşağı düşməsini maneə törədir */
    cursor: pointer;
    transition: all 0.2s ease-in-out;
}

.cat-tab.active {
    background: #212529;
    color: #fff;
    border-color: #212529;
}

/* Grid və Kartlar */
.menu-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(170px, 1fr));
    gap: 12px;
}

.menu-card {
    background: #fff;
    border: 1px solid #edf2f7;
    border-radius: 12px;
    padding: 12px;
    display: flex;
    flex-direction: column;
    justify-content: space-between;
    box-shadow: 0 2px 4px rgba(0,0,0,0.02);
}

.item-name {
    display: block;
    font-weight: 600;
    font-size: 0.95rem;
    color: #333;
    margin-bottom: 4px;
}

.item-price {
    font-size: 0.85rem;
    color: #0d6efd;
    font-weight: 700;
}

/* Miqdar Kontrolu */
.qty-control {
    display: flex;
    align-items: center;
    background: #f1f3f5;
    border-radius: 8px;
    margin-bottom: 8px;
    justify-content: space-between;
}

.qty-btn {
    border: none;
    background: none;
    width: 30px;
    height: 30px;
    font-size: 1.1rem;
    cursor: pointer;
}

.qty-input {
    width: 35px;
    border: none;
    background: transparent;
    text-align: center;
    font-weight: bold;
}

.btn-add-cart {
    width: 100%;
    border: none;
    background: #198754;
    color: white;
    padding: 7px;
    border-radius: 8px;
    font-size: 0.85rem;
    font-weight: 500;
}

/* Kateqoriya Başlıqları */
.category-title {
    font-size: 1rem;
    font-weight: 700;
    margin: 20px 0 10px 0;
    color: #555;
    text-transform: uppercase;
}

@media (max-width: 576px) {
    .menu-grid { grid-template-columns: repeat(2, 1fr); }
    .cat-tab { font-size: 0.8rem; padding: 6px 12px; }
}
</style>


<div class="col-md-7 order-md-1 mb-4">
    <?php if ($is_editable): ?>
        <div class="category-tabs-container mb-3">
            <div class="category-tabs">
                <button class="cat-tab active" data-target="all">Hamısı</button>
                <?php foreach ($menu as $cat_id => $category): ?>
                    <button class="cat-tab" data-target="cat-<?= $cat_id ?>">
                        <?= htmlspecialchars($category['name']) ?>
                    </button>
                <?php endforeach; ?>
            </div>
        </div>

        <div id="menu-container">
            <?php foreach ($menu as $cat_id => $category): if (empty($category['items'])) continue; ?>
                <div class="menu-section mb-4" id="cat-<?= $cat_id ?>">
                    <h5 class="category-title"><?= htmlspecialchars($category['name']) ?></h5>
                    <div class="menu-grid">
                        <?php foreach ($category['items'] as $item): ?>
                            <div class="menu-card">
                                <div class="menu-info">
                                    <span class="item-name"><?= htmlspecialchars($item['name']) ?></span>
                                    <span class="item-price"><?= number_format($item['sale_price'], 2) ?> AZN</span>
                                </div>
                                <form action="order_view_add_item.php?order_id=<?= $order_id ?>" method="POST" class="add-item-form">
                                    <input type="hidden" name="action" value="add_new_item">
                                    <input type="hidden" name="add_item_id" value="<?= $item['id'] ?>">
                                    
                                    <div class="qty-control">
                                        <button type="button" class="qty-btn minus">-</button>
                                        <input type="number" name="quantity" value="1" min="1" class="qty-input">
                                        <button type="button" class="qty-btn plus">+</button>
                                    </div>
                                    
                                    <button type="submit" class="btn-add-cart">
                                        <i class="fas fa-plus"></i> Əlavə et
                                    </button>
                                </form>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php else: ?>
        <div class="alert alert-info shadow-sm text-center">Bu sifariş dəyişdirilə bilməz.</div>
    <?php endif; ?>
</div>
</div>
</div> <div class="modal fade" id="qtyChangeModal" tabindex="-1" aria-labelledby="qtyChangeModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-sm">
    <div class="modal-content">
      <div class="modal-header bg-info text-white">
        <h5 class="modal-title" id="qtyChangeModalLabel"><i class="fas fa-sync-alt me-2"></i> Miqdarı Dəyiş/Sil</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form id="qtyChangeForm" method="POST" action="order_view.php?order_id=<?= $order_id ?>">
        <input type="hidden" name="action" value="update_item_qty">
        <input type="hidden" name="item_id" id="modalItemId">
        
<div class="modal-body">
    <p class="text-danger fw-bold small"><i class="fas fa-exclamation-triangle"></i> Miqdarı azaltdıqda səbəb yazmaq mütləqdir.</p>
    
    <div class="mb-3">
        <label for="new_quantity" class="form-label">Yeni Miqdar:</label>
        <input type="number" name="quantity" id="new_quantity" class="form-control" min="0" required>
    </div>

    <div class="mb-3" id="reason_container" style="display:none;">
        <label class="form-label fw-bold">Silinmə Səbəbi:</label>
        <textarea name="delete_reason" id="delete_reason" class="form-control" rows="2" placeholder="Niyə silinir? (məs: səhv vurulub)"></textarea>
    </div>
</div>
<script>
    document.getElementById('new_quantity').addEventListener('input', function() {
    const originalQty = parseInt(document.getElementById('new_quantity').defaultValue); // Modal açılanda köhnə sayı bura mənimsətməlisiniz
    const currentVal = parseInt(this.value);
    const reasonContainer = document.getElementById('reason_container');
    const reasonInput = document.getElementById('delete_reason');

    if (currentVal < originalQty) {
        reasonContainer.style.display = 'block';
        reasonInput.setAttribute('required', 'required');
    } else {
        reasonContainer.style.display = 'none';
        reasonInput.removeAttribute('required');
    }
});
</script>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Ləğv Et</button>
          <button type="submit" class="btn btn-info" id="modalQtyConfirmBtn">Yenilə/Sil</button>
        </div>
      </form>
    </div>
  </div>
</div>


<script>
document.addEventListener('DOMContentLoaded', function() {
    var qtyChangeModal = new bootstrap.Modal(document.getElementById('qtyChangeModal'));

    // Miqdar Dəyişikliyi Modalı Trigger (yalnız pending/gözləyən xətlər üçün)
    document.querySelectorAll('.item-action-btn').forEach(button => {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            
            const itemId = this.getAttribute('data-item-id');
            const itemQty = this.getAttribute('data-item-qty');
            
            document.getElementById('modalItemId').value = itemId;
            document.getElementById('new_quantity').value = itemQty;
            
            // Düymə mətnini ilkin vəziyyətdə təyin et
            const qty = parseInt(itemQty);
            const btn = document.getElementById('modalQtyConfirmBtn');
             if (qty === 0) {
                btn.textContent = 'Məhsul Xəttini SİL';
                btn.className = 'btn btn-danger';
            } else if (qty > 0) {
                btn.textContent = 'Miqdarı Yenilə';
                btn.className = 'btn btn-info';
            } else {
                 btn.textContent = 'Yenilə/Sil';
                 btn.className = 'btn btn-info';
            }
            
            qtyChangeModal.show();
        });
    });

    // Miqdar Dəyişikliyi Modalında düymə mətnini dinamik dəyişmək
    document.getElementById('new_quantity').addEventListener('input', function() {
        const qty = parseInt(this.value);
        const btn = document.getElementById('modalQtyConfirmBtn');
        if (qty === 0) {
            btn.textContent = 'Məhsul Xəttini SİL';
            btn.className = 'btn btn-danger';
        } else if (qty > 0) {
            btn.textContent = 'Miqdarı Yenilə';
            btn.className = 'btn btn-info';
        } else {
             btn.textContent = 'Yenilə/Sil';
             btn.className = 'btn btn-info';
        }
    });

});
</script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // 1. Kateqoriya Filtrləmə
    const tabs = document.querySelectorAll('.cat-tab');
    const sections = document.querySelectorAll('.menu-section');

    tabs.forEach(tab => {
        tab.addEventListener('click', () => {
            const target = tab.getAttribute('data-target');

            // Aktiv tabı dəyiş
            tabs.forEach(t => t.classList.remove('active'));
            tab.classList.add('active');

            // Bölmələri göstər/gizlə
            sections.forEach(section => {
                if (target === 'all' || section.id === target) {
                    section.style.display = 'block';
                } else {
                    section.style.display = 'none';
                }
            });
        });
    });

    // 2. Miqdar Artırıb-Azaltma (+/-)
    document.querySelectorAll('.qty-control').forEach(control => {
        const minusBtn = control.querySelector('.minus');
        const plusBtn = control.querySelector('.plus');
        const input = control.querySelector('.qty-input');

        minusBtn.addEventListener('click', (e) => {
            e.preventDefault();
            let val = parseInt(input.value);
            if (val > 1) input.value = val - 1;
        });

        plusBtn.addEventListener('click', (e) => {
            e.preventDefault();
            let val = parseInt(input.value);
            input.value = val + 1;
        });
    });
});
</script>
<script>
function printAndCloseOrder() {
    // 1. Çap prosesi
    const receiptHtml = document.getElementById('thermal-receipt').innerHTML;
    const originalBody = document.body.innerHTML;

    document.body.innerHTML = receiptHtml;
    window.print();
    
    // 2. Formu göndər (Masanı bazada qapatmaq üçün)
    // Qeyd: body dəyişdiyi üçün formu yenidən tapıb göndərməliyik
    document.body.innerHTML = originalBody;
    document.getElementById('finalizeOrderForm').submit();
}

function onlyPrintReceipt() {
    const receiptHtml = document.getElementById('thermal-receipt').innerHTML;
    const printWindow = window.open('', '_blank', 'height=600,width=400');
    
    printWindow.document.write('<html><head><title>Çek Önizləmə</title></head><body>');
    printWindow.document.write(receiptHtml);
    printWindow.document.write('</body></html>');
    printWindow.document.close();
    printWindow.print();
}
</script>
<script>
    const scrollContainer = document.querySelector('.category-tabs-container');

scrollContainer.addEventListener('wheel', (evt) => {
    evt.preventDefault();
    scrollContainer.scrollLeft += evt.deltaY;
});

// Əlavə olaraq: Siçanla tutub sürüşdürmək üçün (Drag to scroll)
let isDown = false;
let startX;
let scrollLeft;

scrollContainer.addEventListener('mousedown', (e) => {
    isDown = true;
    scrollContainer.classList.add('active');
    startX = e.pageX - scrollContainer.offsetLeft;
    scrollLeft = scrollContainer.scrollLeft;
});
scrollContainer.addEventListener('mouseleave', () => {
    isDown = false;
});
scrollContainer.addEventListener('mouseup', () => {
    isDown = false;
});
scrollContainer.addEventListener('mousemove', (e) => {
    if(!isDown) return;
    e.preventDefault();
    const x = e.pageX - scrollContainer.offsetLeft;
    const walk = (x - startX) * 2; // Sürət
    scrollContainer.scrollLeft = scrollLeft - walk;
});
</script>

<style>
/* Ekran üçün stil: Çap şablonu heç vaxt görünməsin */
@media screen {
    #thermal-receipt { display: none !important; }
}

/* Çap üçün stil: Yalnız çek görünsün */
@media print {
    body * { display: none !important; }
    #thermal-receipt { display: block !important; position: absolute; left: 0; top: 0; width: 80mm; }
    #thermal-receipt * { display: block !important; }
}
</style>

<?php
require_once '../includes/footer.php';
?>