<?php
session_start();
$page_title = "Yeni Sifariş Yarat";
require_once '../includes/header.php'; 

// Yalnız Ofisiant (və ya Admin) giriş edə bilər
if ($_SESSION['role'] !== 'waiter' && $_SESSION['role'] !== 'admin') {
    header('Location: ../index.php');
    exit;
}

$error = '';
$table_id = (int)($_GET['table_id'] ?? 0);

if ($table_id === 0) {
    $error = "Masa ID-si tapılmadı. Zəhmət olmasa masanı seçin.";
}

$table_info = [];
$active_order_id = null; 

// --- MASA MƏLUMATLARI VƏ AKTİV SİFARİŞİN YOXLANILMASI ---
if ($table_id > 0 && empty($error)) {
    // Masanın məlumatlarını və aktiv sifarişin ID-sini (varsa) bir sorğu ilə çəkirik
    $stmt = $conn->prepare("
        SELECT 
            t.table_number, t.capacity, 
            o.id AS active_order_id 
        FROM tables t
        LEFT JOIN orders o ON t.id = o.table_id AND o.status = 'active'
        WHERE t.id = ?
    ");
    $stmt->bind_param("i", $table_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 1) {
        $data = $result->fetch_assoc();
        $table_info = ['table_number' => $data['table_number'], 'capacity' => $data['capacity']];
        $active_order_id = $data['active_order_id'];
    } else {
        $error = "Seçilmiş masa tapılmadı.";
    }
    $stmt->close();

    // ƏGƏR AKTİV SİFARİŞ VARSA, YÖNLƏNDİR
    if (!empty($active_order_id)) {
        // Bu hissə işləmirsə, problem `index.php` faylının sorğusunda olub.
        // İndi həm burada, həm də `index.php`də eyni sorğunu istifadə etdik.
        header('Location: order_view.php?order_id=' . $active_order_id);
        exit;
    }
}


// --- POST Əməliyyatı: Yeni Sifarişin Açılması (yalnız doluluq yoxlandıqdan sonra) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['table_id'])) {
    
    // POST-la gələn ID-ni yenidən yoxlamaq lazımdır, əgər kimsə URL-i dəyişsə
    $temp_table_id = (int)$_POST['table_id'];
    $check_stmt = $conn->prepare("SELECT id FROM orders WHERE table_id = ? AND status = 'active'");
    $check_stmt->bind_param("i", $temp_table_id);
    $check_stmt->execute();
    if ($check_stmt->get_result()->num_rows > 0) {
        // Yenidən yoxlama: POST gəlsə belə, aktiv sifariş varsa, icazə vermə
        $check_stmt->close();
        header('Location: index.php?error=' . urlencode('Bu masada artıq aktiv sifariş var.'));
        exit;
    }
    $check_stmt->close();


    $waiter_id = $_SESSION['user_id'] ?? null; 
    
    if ($waiter_id === null) {
        $error = "Ofisiant məlumatı tapılmadı. Zəhmət olmasa yenidən daxil olun.";
        header('Location: ../login.php?error=' . urlencode($error));
        exit;
    }
    
    $initial_total = 0.00; 
    
    $stmt = $conn->prepare("INSERT INTO orders (table_id, waiter_id, total_amount) VALUES (?, ?, ?)");
    
    if ($stmt) {
        $stmt->bind_param("iid", $temp_table_id, $waiter_id, $initial_total);
        
        if ($stmt->execute()) { 
            $new_order_id = $conn->insert_id;
            $message = "Masa " . htmlspecialchars($table_info['table_number'] ?? $temp_table_id) . " üçün yeni sifariş #{$new_order_id} uğurla açıldı. Məhsul əlavə edin.";
            
            header('Location: order_view.php?order_id=' . $new_order_id . '&message=' . urlencode($message));
            exit;
        } else {
            $error = "Sifariş açıla bilmədi. DB Xətası: " . $stmt->error;
        }
        $stmt->close();
    } else {
        $error = "SQL Sorğu Səhvi: " . $conn->error;
    }

    // Əgər xəta varsa, səhifəni yenidən yüklə
    header('Location: index.php?error=' . urlencode($error));
    exit;
}
?>

<div class="row">
    <div class="col-md-6 offset-md-3">
        <?php if (!empty($error) && empty($active_order_id)): // Aktiv sifariş varsa, səhv mesajı göstərməyə ehtiyac yoxdur, yönləndirilib ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-triangle me-2"></i> <?= htmlspecialchars($error) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <?php 
        // Yalnız masa tapılıbsa VƏ aktiv sifariş yoxdursa formanı göstəririk
        if (!empty($table_info) && empty($error) && empty($active_order_id)): ?>
            <div class="card shadow">
                <div class="card-header bg-success text-white">
                    <h4 class="mb-0"><i class="fas fa-plus-circle me-2"></i> Yeni Sifariş Açmaq</h4>
                </div>
                <div class="card-body text-center">
                    <h2 class="mb-4">Masa: <?= htmlspecialchars($table_info['table_number']) ?></h2>
                    <p class="text-muted">Tutumu: <?= htmlspecialchars($table_info['capacity']) ?> nəfər</p>
                    
                    <p class="lead fw-bold">Bu masa üçün yeni sifariş açmağa əminsiniz?</p>

                    <form action="order_create.php" method="POST" class="mt-4">
                        <input type="hidden" name="table_id" value="<?= $table_id ?>">
                        <button type="submit" class="btn btn-success btn-lg">
                            <i class="fas fa-concierge-bell me-2"></i> Yeni Sifariş Aç
                        </button>
                    </form>

                    <a href="index.php" class="btn btn-outline-secondary mt-3">
                        <i class="fas fa-arrow-left me-2"></i> Geri Qayıt
                    </a>

                </div>
            </div>
        <?php elseif(empty($error) && empty($table_info) && $table_id > 0): ?>
             <div class="alert alert-warning text-center">
                 <i class="fas fa-exclamation-circle me-2"></i> Seçilən masa tapılmadı.
             </div>
        <?php endif; ?>
    </div>
</div>

<?php
require_once '../includes/footer.php';
?>