<?php
session_start();
$page_title = "Masaların İdarə Edilməsi";
require_once '../includes/header.php'; 

// Yalnız Adminlər bu səhifəyə daxil ola bilər
if ($_SESSION['role'] !== 'admin') {
    header('Location: index.php');
    exit;
}

$message = $_GET['message'] ?? '';
$error = $_GET['error'] ?? '';

// --- 1. Silmə Əməliyyatı (DELETE) (Dəyişməyib) ---
if (isset($_GET['action']) && $_GET['action'] == 'delete' && isset($_GET['id'])) {
    $table_id = (int)$_GET['id'];
    
    $stmt = $conn->prepare("DELETE FROM tables WHERE id = ?");
    $stmt->bind_param("i", $table_id);
    
    if ($stmt->execute()) {
        $message = "Masa uğurla silindi.";
    } else {
        $error = "Silmək mümkün olmadı. Masada aktiv sifariş ola bilər və ya digər səhv var.";
    }
    $stmt->close();
    
    header('Location: tables.php?message=' . urlencode($message) . '&error=' . urlencode($error));
    exit;
}

// --- 2. Yaratma/Dəyişdirmə Əməliyyatı (CREATE / UPDATE) (YENİLƏNİB - sort_order əlavə edildi) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $table_number = trim($_POST['table_number']);
    $capacity = (int)$_POST['capacity'];
    $type = $_POST['type']; 
    $is_active = isset($_POST['is_active']) ? 1 : 0; 
    $sort_order = (int)$_POST['sort_order']; // YENİ: Sıralama nömrəsi
    $edit_id = (isset($_POST['edit_id']) && $_POST['edit_id'] != '') ? (int)$_POST['edit_id'] : null;

    if ($edit_id) {
        // UPDATE əməliyyatı
        $stmt = $conn->prepare("UPDATE tables SET table_number = ?, capacity = ?, type = ?, is_active = ?, sort_order = ? WHERE id = ?");
        $stmt->bind_param("sisiia", $table_number, $capacity, $type, $is_active, $sort_order, $edit_id);
        $action_message = "Masa uğurla dəyişdirildi.";
    } else {
        // CREATE əməliyyatı
        $stmt = $conn->prepare("INSERT INTO tables (table_number, capacity, type, is_active, sort_order) VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param("sisis", $table_number, $capacity, $type, $is_active, $sort_order);
        $action_message = "Yeni masa uğurla əlavə edildi.";
    }

    if ($stmt->execute()) {
        $message = $action_message;
    } else {
        $error = "Əməliyyat uğursuz oldu: Masa nömrəsi təkrarlana bilər və ya digər səhv var.";
    }
    $stmt->close();
    
    header('Location: tables.php?message=' . urlencode($message) . '&error=' . urlencode($error));
    exit;
}

// --- 3. Dəyişdirmə üçün Datayı Yükləmə (READ Single) (YENİLƏNİB) ---
$table_to_edit = null;
if (isset($_GET['action']) && $_GET['action'] == 'edit' && isset($_GET['id'])) {
    $edit_id = $_GET['id'];
    $stmt = $conn->prepare("SELECT id, table_number, capacity, type, is_active, sort_order FROM tables WHERE id = ?");
    $stmt->bind_param("i", $edit_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows == 1) {
        $table_to_edit = $result->fetch_assoc();
    }
    $stmt->close();
}

// --- 4. Bütün Masaların Siyahısı (READ All) (YENİLƏNİB - Sıralanma əlavə edildi) ---
$tables = [];
// Masaları Öncə sort_order-ə, sonra id-yə görə sıralayırıq.
$result = $conn->query("SELECT id, table_number, capacity, type, is_active, created_at, sort_order FROM tables ORDER BY sort_order ASC, id ASC");
if ($result && $result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $tables[] = $row;
    }
}

// Masa Tipləri üçün Assosiativ Massiv
$table_types = [
    'otaq' => 'Otaq',
    'kabinet' => 'Kabinet',
    'zal' => 'Zal',
    'digər' => 'Digər'
];
?>

<?php if ($message): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert"><i class="fas fa-check-circle me-2"></i> <?= htmlspecialchars($message) ?><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>
<?php endif; ?>
<?php if ($error): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert"><i class="fas fa-exclamation-triangle me-2"></i> <?= htmlspecialchars($error) ?><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>
<?php endif; ?>

<div class="row">
    <div class="col-lg-4 mb-4">
        <div class="card shadow">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold"><?= $table_to_edit ? 'Masayı Dəyişdir' : 'Yeni Masa Əlavə Et' ?></h6>
            </div>
            <div class="card-body">
                <form action="tables.php" method="POST">
                    <input type="hidden" name="edit_id" value="<?= $table_to_edit ? $table_to_edit['id'] : '' ?>">
                    
                    <div class="mb-3">
                        <label for="table_number" class="form-label">Masa Nömrəsi/Adı</label>
                        <input type="text" class="form-control" id="table_number" name="table_number" 
                               value="<?= $table_to_edit ? htmlspecialchars($table_to_edit['table_number']) : '' ?>" required>
                    </div>

                    <div class="mb-3">
                        <label for="sort_order" class="form-label">Sıralama Nömrəsi (1 = Ən öndə)</label>
                        <input type="number" min="1" class="form-control" id="sort_order" name="sort_order" 
                               value="<?= $table_to_edit ? htmlspecialchars($table_to_edit['sort_order']) : '99' ?>" required>
                    </div>
                    
                    <div class="mb-3">
                        <label for="capacity" class="form-label">Tutumu (Nəfər)</label>
                        <input type="number" min="1" class="form-control" id="capacity" name="capacity" 
                               value="<?= $table_to_edit ? htmlspecialchars($table_to_edit['capacity']) : '4' ?>" required>
                    </div>

                    <div class="mb-3">
                        <label for="type" class="form-label">Masa Tipi</label>
                        <select class="form-select" id="type" name="type" required>
                            <?php foreach ($table_types as $key => $value): ?>
                                <option value="<?= $key ?>" 
                                    <?= ($table_to_edit && $table_to_edit['type'] === $key) ? 'selected' : '' ?>>
                                    <?= $value ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="mb-3 form-check">
                        <?php 
                            $is_active_checked = true; 
                            if ($table_to_edit) {
                                $is_active_checked = (bool)$table_to_edit['is_active'];
                            }
                        ?>
                        <input type="checkbox" class="form-check-input" id="is_active" name="is_active" 
                               value="1" <?= $is_active_checked ? 'checked' : '' ?>>
                        <label class="form-check-label" for="is_active">Masayı Aktivləşdir</label>
                    </div>

                    <div class="d-grid">
                        <button type="submit" class="btn btn-dark">
                            <i class="fas <?= $table_to_edit ? 'fa-edit' : 'fa-plus-circle' ?> me-2"></i>
                            <?= $table_to_edit ? 'Yadda Saxla' : 'Masayı Əlavə Et' ?>
                        </button>
                    </div>
                    <?php if ($table_to_edit): ?>
                        <div class="d-grid mt-2">
                            <a href="tables.php" class="btn btn-outline-secondary">Ləğv Et</a>
                        </div>
                    <?php endif; ?>
                </form>
            </div>
        </div>
    </div>

    <div class="col-lg-8">
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-dark">Bütün Masalar</h6>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Sıra</th> <th>Masa Adı/Nömrəsi</th>
                                <th>Tutumu</th>
                                <th>Tipi</th> 
                                <th>Status</th> 
                                <th>Əlavə Edilmə Tarixi</th> 
                                <th>Əməliyyatlar</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($tables)): ?>
                                <?php foreach ($tables as $table): ?>
                                    <tr>
                                        <td><?= $table['id'] ?></td>
                                        <td><span class="badge bg-primary"><?= $table['sort_order'] ?></span></td> <td><?= htmlspecialchars($table['table_number']) ?></td>
                                        <td><?= $table['capacity'] ?> Nəfər</td>
                                        <td><span class="badge bg-secondary"><?= $table_types[$table['type']] ?? 'Naməlum' ?></span></td>
                                        <td>
                                            <?php if ($table['is_active']): ?>
                                                <span class="badge bg-success"><i class="fas fa-check-circle"></i> Aktiv</span>
                                            <?php else: ?>
                                                <span class="badge bg-danger"><i class="fas fa-times-circle"></i> Deaktiv</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?= date('d.m.Y H:i', strtotime($table['created_at'])) ?></td>
                                        <td>
                                            <a href="tables.php?action=edit&id=<?= $table['id'] ?>" class="btn btn-sm btn-info me-2" title="Dəyişdir">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <a href="tables.php?action=delete&id=<?= $table['id'] ?>" 
                                               class="btn btn-sm btn-danger" 
                                               onclick="return confirm('Masa silinəcək. Əminsiniz?')"
                                               title="Sil">
                                                <i class="fas fa-trash-alt"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="8" class="text-center text-muted">Hələ heç bir masa əlavə edilməyib.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
require_once '../includes/footer.php';
?>