<?php
session_start();
$page_title = "Menyu Məhsulları";
require_once '../includes/header.php'; 

// Yalnız Adminlər bu səhifəyə daxil ola bilər (Əgər bu yoxdursa, əlavə edin)
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header('Location: index.php');
    exit;
}

$message = $_GET['message'] ?? '';
$error = $_GET['error'] ?? '';

// Bütün kateqoriyaları yükləyirik (Menyuya kateqoriya seçmək üçün)
$categories = [];
$cat_result = $conn->query("SELECT id, name FROM categories WHERE is_active = 1 ORDER BY sort_order ASC, name ASC"); 
if ($cat_result && $cat_result->num_rows > 0) {
    while($row = $cat_result->fetch_assoc()) {
        $categories[] = $row;
    }
} else if (!$cat_result) {
    $error = "Kateqoriyaları yükləmək mümkün olmadı: " . $conn->error;
}


// --- 1. Silmə Əməliyyatı (DELETE) (Dəyişməyib) ---
if (isset($_GET['action']) && $_GET['action'] == 'delete' && isset($_GET['id'])) {
    $item_id = (int)$_GET['id'];
    
    $stmt = $conn->prepare("DELETE FROM menu_items WHERE id = ?");
    $stmt->bind_param("i", $item_id);
    
    if ($stmt->execute()) {
        $message = "Menyu məhsulu uğurla silindi.";
    } else {
        $error = "Silmək mümkün olmadı: " . $conn->error;
    }
    $stmt->close();
    
    header('Location: menu.php?message=' . urlencode($message) . '&error=' . urlencode($error));
    exit;
}

// --- 2. Yaratma/Dəyişdirmə Əməliyyatı (CREATE / UPDATE) (YENİLƏNİB) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $category_id = (int)$_POST['category_id'];
    $name = trim($_POST['name']);
    $sale_price = (float)$_POST['sale_price'];
    $purchase_price = (float)$_POST['purchase_price'];
    $description = trim($_POST['description']);
    
    $sort_order = (int)$_POST['sort_order'];
    $is_active = isset($_POST['is_active']) ? 1 : 0;
    $is_available = isset($_POST['is_available']) ? 1 : 0;
    $is_kitchen_item = isset($_POST['is_kitchen_item']) ? 1 : 0; // YENİ
    
    $edit_id = (isset($_POST['edit_id']) && $_POST['edit_id'] != '') ? (int)$_POST['edit_id'] : null;

    if ($edit_id) {
        // UPDATE əməliyyatı
        $stmt = $conn->prepare("UPDATE menu_items SET category_id=?, name=?, sale_price=?, purchase_price=?, description=?, sort_order=?, is_active=?, is_available=?, is_kitchen_item=? WHERE id=?");
        $stmt->bind_param("isddsiiiii", $category_id, $name, $sale_price, $purchase_price, $description, $sort_order, $is_active, $is_available, $is_kitchen_item, $edit_id);
        $action_message = "Menyu məhsulu uğurla dəyişdirildi.";
    } else {
        // CREATE əməliyyatı
        $stmt = $conn->prepare("INSERT INTO menu_items (category_id, name, sale_price, purchase_price, description, sort_order, is_active, is_available, is_kitchen_item) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("isddsiiii", $category_id, $name, $sale_price, $purchase_price, $description, $sort_order, $is_active, $is_available, $is_kitchen_item);
        $action_message = "Yeni menyu məhsulu uğurla əlavə edildi.";
    }

    if ($stmt->execute()) {
        $message = $action_message;
    } else {
        $error = "Əməliyyat uğursuz oldu: " . $conn->error;
    }
    $stmt->close();
    
    header('Location: menu.php?message=' . urlencode($message) . '&error=' . urlencode($error));
    exit;
}

// --- 3. Dəyişdirmə üçün Datayı Yükləmə (READ Single) (YENİLƏNİB) ---
$item_to_edit = null;
if (isset($_GET['action']) && $_GET['action'] == 'edit' && isset($_GET['id'])) {
    $edit_id = (int)$_GET['id'];
    // Yeni sütunlar əlavə edildi
    $stmt = $conn->prepare("SELECT id, category_id, name, sale_price, purchase_price, description, sort_order, is_active, is_available, is_kitchen_item FROM menu_items WHERE id = ?");
    $stmt->bind_param("i", $edit_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows == 1) {
        $item_to_edit = $result->fetch_assoc();
    }
    $stmt->close();
}


// --- 4. Bütün Məhsulların Siyahısı (READ All) (YENİLƏNİB) ---
$menu_items = [];
$sql = "SELECT m.*, c.name as category_name 
        FROM menu_items m 
        JOIN categories c ON m.category_id = c.id
        ORDER BY m.sort_order ASC, m.id DESC"; 
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $menu_items[] = $row;
    }
}

// Məhsul növləri üçün massiv (göstərmək üçün)
$product_types = [
    1 => ['name' => 'Mətbəx Məhsulu', 'badge' => 'primary', 'icon' => 'fas fa-utensils'],
    0 => ['name' => 'Hazır Məhsul', 'badge' => 'secondary', 'icon' => 'fas fa-box-open'],
];
?>

<?php if ($message): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert"><i class="fas fa-check-circle me-2"></i> <?= htmlspecialchars($message) ?><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>
<?php endif; ?>
<?php if ($error): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert"><i class="fas fa-exclamation-triangle me-2"></i> <?= htmlspecialchars($error) ?><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>
<?php endif; ?>

<div class="row">
    <div class="col-lg-4 mb-4">
        <div class="card shadow">
            <div class="card-header py-3" style="background-color: #20c997; color: white;">
                <h6 class="m-0 font-weight-bold"><?= $item_to_edit ? 'Məhsulu Dəyişdir' : 'Yeni Məhsul Əlavə Et' ?></h6>
            </div>
            <div class="card-body">
                <form action="menu.php" method="POST">
                    <input type="hidden" name="edit_id" value="<?= $item_to_edit ? $item_to_edit['id'] : '' ?>">
                    
                    <div class="mb-3">
                        <label for="category_id" class="form-label">Kateqoriya</label>
                        <select class="form-select" id="category_id" name="category_id" required>
                            <option value="">Kateqoriya seçin</option>
                            <?php foreach ($categories as $category): ?>
                                <option value="<?= $category['id'] ?>"
                                    <?= ($item_to_edit && $item_to_edit['category_id'] == $category['id']) ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($category['name']) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="name" class="form-label">Məhsulun Adı</label>
                        <input type="text" class="form-control" id="name" name="name" 
                               value="<?= $item_to_edit ? htmlspecialchars($item_to_edit['name']) : '' ?>" required>
                    </div>

                    <div class="mb-3 form-check form-switch">
                        <?php 
                            $is_kitchen_item_checked = true; 
                            if ($item_to_edit) {
                                $is_kitchen_item_checked = (bool)$item_to_edit['is_kitchen_item'];
                            }
                        ?>
                        <input type="checkbox" class="form-check-input" id="is_kitchen_item" name="is_kitchen_item" 
                               value="1" <?= $is_kitchen_item_checked ? 'checked' : '' ?>>
                        <label class="form-check-label" for="is_kitchen_item">Bu Məhsul **Mətbəxdə Hazırlanır**</label>
                        <small class="text-muted d-block">(Qeyri-aktivdirsə, **Hazır Məhsuldur** (İçki, Qutu Suyu və s.))</small>
                    </div>
                    
                    <div class="mb-3">
                        <label for="sort_order" class="form-label">Sıralama Nömrəsi (1 = Ən öndə)</label>
                        <input type="number" min="1" class="form-control" id="sort_order" name="sort_order" 
                               value="<?= $item_to_edit ? htmlspecialchars($item_to_edit['sort_order']) : '99' ?>" required>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="sale_price" class="form-label">Satış Qiyməti (AZN)</label>
                            <input type="number" step="0.01" min="0.01" class="form-control" id="sale_price" name="sale_price" 
                                   value="<?= $item_to_edit ? htmlspecialchars($item_to_edit['sale_price']) : '' ?>" required>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="purchase_price" class="form-label">Maya Dəyəri (AZN)</label>
                            <input type="number" step="0.01" min="0" class="form-control" id="purchase_price" name="purchase_price" 
                                   value="<?= $item_to_edit ? htmlspecialchars($item_to_edit['purchase_price']) : '' ?>" required>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="description" class="form-label">Qısa Təsvir (Opsiyonel)</label>
                        <textarea class="form-control" id="description" name="description" rows="2"><?= $item_to_edit ? htmlspecialchars($item_to_edit['description']) : '' ?></textarea>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3 form-check form-switch">
                            <?php 
                                $is_active_checked = true;
                                if ($item_to_edit) {
                                    $is_active_checked = (bool)$item_to_edit['is_active'];
                                }
                            ?>
                            <input type="checkbox" class="form-check-input" id="is_active" name="is_active" 
                                   value="1" <?= $is_active_checked ? 'checked' : '' ?>>
                            <label class="form-check-label" for="is_active">Menyuda Görünsün</label>
                        </div>

                        <div class="col-md-6 mb-3 form-check form-switch">
                            <?php 
                                $is_available_checked = true;
                                if ($item_to_edit) {
                                    $is_available_checked = (bool)$item_to_edit['is_available'];
                                }
                            ?>
                            <input type="checkbox" class="form-check-input" id="is_available" name="is_available" 
                                   value="1" <?= $is_available_checked ? 'checked' : '' ?>>
                            <label class="form-check-label" for="is_available">Restoranda Var</label>
                            <small class="text-muted d-block">(Bitibsə, qeyri-aktiv edin)</small>
                        </div>
                    </div>
                    
                    <div class="d-grid mt-3">
                        <button type="submit" class="btn btn-dark">
                            <i class="fas <?= $item_to_edit ? 'fa-edit' : 'fa-plus-circle' ?> me-2"></i>
                            <?= $item_to_edit ? 'Yadda Saxla' : 'Məhsulu Əlavə Et' ?>
                        </button>
                    </div>
                    <?php if ($item_to_edit): ?>
                        <div class="d-grid mt-2">
                            <a href="menu.php" class="btn btn-outline-secondary">Ləğv Et</a>
                        </div>
                    <?php endif; ?>
                </form>
            </div>
        </div>
    </div>

    <div class="col-lg-8">
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-dark">Bütün Menyu Məhsulları</h6>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Sıra</th>
                                <th>Adı</th>
                                <th>Kateqoriya</th>
                                <th>Tipi</th> <th>Satış Q.</th>
                                <th>Qazanc</th>
                                <th>Status</th>
                                <th>Restoranda Var</th> <th>Əlavə Edilmə Tarixi</th>
                                <th>Əməliyyatlar</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($menu_items)): ?>
                                <?php foreach ($menu_items as $item): 
                                    $profit = $item['sale_price'] - $item['purchase_price'];
                                    $type_data = $product_types[(int)$item['is_kitchen_item']]; // Tip məlumatını alırıq
                                ?>
                                    <tr>
                                        <td><?= $item['id'] ?></td>
                                        <td><span class="badge bg-primary"><?= $item['sort_order'] ?></span></td>
                                        <td><?= htmlspecialchars($item['name']) ?></td>
                                        <td><?= htmlspecialchars($item['category_name']) ?></td>
                                        <td>
                                            <span class="badge bg-<?= $type_data['badge'] ?>">
                                                <i class="<?= $type_data['icon'] ?>"></i> <?= $type_data['name'] ?>
                                            </span>
                                        </td>
                                        <td><?= number_format($item['sale_price'], 2) ?> AZN</td>
                                        <td class="<?= $profit > 0 ? 'text-success' : 'text-danger' ?>">
                                            <?= number_format($profit, 2) ?> AZN
                                        </td>
                                        <td>
                                            <?php if ($item['is_active']): ?>
                                                <span class="badge bg-success">Aktiv</span>
                                            <?php else: ?>
                                                <span class="badge bg-warning text-dark">Deaktiv</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if ($item['is_available']): ?>
                                                <span class="badge bg-success"><i class="fas fa-check"></i> Var</span>
                                            <?php else: ?>
                                                <span class="badge bg-danger"><i class="fas fa-times"></i> Bitib</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?= date('d.m.Y', strtotime($item['created_at'])) ?></td>
                                        <td>
                                            <a href="menu.php?action=edit&id=<?= $item['id'] ?>" class="btn btn-sm btn-info me-2" title="Dəyişdir">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <a href="menu.php?action=delete&id=<?= $item['id'] ?>" 
                                               class="btn btn-sm btn-danger" 
                                               onclick="return confirm('Məhsul silinəcək. Əminsiniz?')"
                                               title="Sil">
                                                <i class="fas fa-trash-alt"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="11" class="text-center text-muted">Hələ heç bir menyu məhsulu əlavə edilməyib.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
require_once '../includes/footer.php';
?>